/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CFM-MESP.cp,v 1.4 1999/03/10 02:33:16 heller Exp $
____________________________________________________________________________*/

#include <CodeFragments.h>
#include <MixedMode.h>

#include "plugin.h"


enum {
	kFinderSignature = 'MACS'
};


	SInt32								// Error code
main (
	ProcessInfoRec *	inProcInfo,	// Proc info for captured browser
	FSSpec *			inFSSpec)	// FSSpec for this plugin
{
	OSErr				err;
	SInt32				result;

	// Check for CFM
	SInt32	response;
	
	err = ::Gestalt(gestaltCFMAttr, &response);
	if ((err != noErr) || (((response >> gestaltCFMPresent) & 1) != 1)) {
		result = kUnknownErr;
	} else {
		// Load the library
		CFragConnectionID	connID;
		Ptr					mainAddr;
		Str255				errName;
		THz					savedZone = ::GetZone();

		// If the app is the finder, we need to load in the system zone
		if (inProcInfo->processSignature == kFinderSignature) {
			::SetZone(::SystemZone());
		}
		err = ::GetDiskFragment(	inFSSpec,
									0L,
									kCFragGoesToEOF,
									inProcInfo->processName,
									kLoadCFrag,
									&connID,
									(Ptr*)&mainAddr,
									errName);
		::SetZone(savedZone);
		if (err != noErr) {
			result = kUnknownErr;
		} else {	
			// Create the UPP
			PlugInMainProcUPP	mainUPP;

			mainUPP = (PlugInMainProcUPP) ::NewRoutineDescriptorTrap(
											(ProcPtr) mainAddr,
											uppPlugInMainProcInfo,
											CFM_MESPTarget_);
			if (mainUPP == nil) {
				::CloseConnection(& connID);
				result = kOutOfMemoryErr;
			} else {
				savedZone = ::GetZone();
				::SetZone(::SystemZone());
				result = CallPlugInMainProc(mainUPP, inProcInfo, inFSSpec);
				::SetZone(savedZone);
				::DisposeRoutineDescriptorTrap((UniversalProcPtr) mainUPP);
				
				// Close the connection if we are not patching
				if (result != noErr) {
					::CloseConnection(& connID);
				}
			}
		}
	}
	
	return result | kUnloadPlug;
}
